%define module_name Perl-Critic-Policy-ProhibitOrReturn
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Perl/Critic.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Do not use `or return`
Group: Development/Perl
License: perl
URL: https://github.com/utgwkk/Perl-Critic-Policy-ProhibitOrReturn

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTGWKK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Avoid using `or return'. Consider using equivalent `if' (or `unless') statement instead.

    # not ok
    sub foo {
        my ($x) = @_;
        $x or return;
        ...
    }

    # ok
    sub foo {
        my ($x) = @_;
        return if !$x;
        ...
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/P*

%changelog
