%define module_name Perl-Critic-Policy-ValuesAndExpressions-PreventSQLInjection
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(PPI.pm) perl(PPIx/QuoteLike.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/Utils.pm) perl(Readonly.pm) perl(String/InterpolatedVariables.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Perl/Critic/Policy.pm) perl(Try/Tiny.pm) perl(base.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.000001
Release: alt1
Summary: Prevent SQL injection in interpolated strings.
Group: Development/Perl
License: perl
URL: https://github.com/oalders/Perl-Critic-Policy-ValuesAndExpressions-PreventSQLInjection

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OA/OALDERS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
When building SQL statements manually instead of using an ORM, any input must
be quoted or passed using placeholders to prevent the introduction of SQL
injection vectors. This policy attempts to detect the most common sources of
SQL injection in manually crafted SQL statements, by detecting the use of
variables inside interpolated strings that look like SQL statements.

In other words, this policy searches for code such as:

_my $sql = "SELECT * FROM $table WHERE field = $value";

But would leave alone:

_my $string = "Hello $world";



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTORS LICENSE README.md examples
%perl_vendor_privlib/P*

%changelog
