%define module_name Perl-Critic-Policy-Variables-RequireHungarianNotation
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Perl/Critic/Policy.pm) perl(Perl/Critic/TestUtils.pm) perl(Perl/Critic/Utils.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.7
Release: alt1
Summary: Critic policy for hungarian notation.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MZ/MZIESCHA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Don't let anyone guess which type you expect in your code:

    my @array    = ();    # don't do this
    my %%hash     = ();    # or this
    my $hashref  = {};    # or this
    my $arrayref = [];    # or this
    my $string   = '';    # or this

The policy is also running through sub declarations.    

    # won't work
    sub some_sub {
        my ($self, $arrayref, $string) = @_;
        ...
    }

Instead, do this:

    my @a_array     = (); # do this
    my %%h_hash      = (); # and this
    my $hr_hashref  = {}; # and this
    my $hr_arrayref = []; # and this
    my $s_string    = ''; # and this

    # this will (hopefuly)
    sub some_sub {
        my ($self, $ar_arrayref, $s_string) = @_;
        ...
    }

$self as variable is excluded.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/P*

%changelog
