Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Foo.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Perl-Critic-StricterSubs
Version:        0.08
Release:        alt1_3
Summary:        Perl::Critic plugin for stricter subroutine checks
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Perl-Critic-StricterSubs
Source0:        https://cpan.metacpan.org/authors/id/P/PE/PETDANCE/Perl-Critic-StricterSubs-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/PathList.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(Perl/Critic/Exception/Configuration/Option/Policy/ParameterValue.pm)
BuildRequires:  perl(Perl/Critic/Policy.pm)
BuildRequires:  perl(Perl/Critic/Utils.pm)
BuildRequires:  perl(PPI/Document.pm)
BuildRequires:  perl(Readonly.pm)
# Tests:
BuildRequires:  perl(Perl/Critic/TestUtils.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Warnings.pm)
Requires:       perl(Perl/Critic/Policy.pm) >= 1.082
Requires:       perl(Perl/Critic/Utils.pm) >= 1.082

# Filter under-specified dependencies:

# Do not provide private modules

Source44: import.info
%filter_from_requires /^perl(Perl.Critic.\(Policy\|TestUtils\|Utils\).pm)/d
%filter_from_provides /^perl(\(EmptyExports\|HasExports\|NoExports\).pm)/d

%description
As a dynamic language, Perl doesn't require you to define subroutines until
run-time. Although this is a powerful feature, it can also be a major source
of bugs. The Perl::Critic::Policy modules in this distribution are aimed at
reducing errors caused by invoking subroutines that are not defined.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Perl/Critic/TestUtils.pm) >= 1.082

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Perl-Critic-StricterSubs-%{version}
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=%{buildroot} create_packlist=0
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes README
%dir %{perl_vendor_privlib}/Perl
%dir %{perl_vendor_privlib}/Perl/Critic
%dir %{perl_vendor_privlib}/Perl/Critic/Policy
%dir %{perl_vendor_privlib}/Perl/Critic/Policy/Modules
%{perl_vendor_privlib}/Perl/Critic/Policy/Modules/RequireExplicitInclusion.pm
%dir %{perl_vendor_privlib}/Perl/Critic/Policy/Subroutines
%{perl_vendor_privlib}/Perl/Critic/Policy/Subroutines/ProhibitCallsToUndeclaredSubs.pm
%{perl_vendor_privlib}/Perl/Critic/Policy/Subroutines/ProhibitCallsToUnexportedSubs.pm
%{perl_vendor_privlib}/Perl/Critic/Policy/Subroutines/ProhibitExportingUndeclaredSubs.pm
%{perl_vendor_privlib}/Perl/Critic/Policy/Subroutines/ProhibitQualifiedSubDeclarations.pm
%{perl_vendor_privlib}/Perl/Critic/StricterSubs
%{perl_vendor_privlib}/Perl/Critic/StricterSubs.pm

%files tests
%{_libexecdir}/%{name}

%changelog
