Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This file is lincesed under the terms of GNU GPLv2+.
Name:           perl-Perl-Critic-Tics
Version:        0.010
Release:        alt1_8
Summary:        Policies for things that make me wince
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Perl-Critic-Tics
Source0:        https://cpan.metacpan.org/authors/id/R/RJ/RJBS/Perl-Critic-Tics-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Perl/Critic/Policy.pm)
BuildRequires:  perl(Perl/Critic/Utils.pm)
BuildRequires:  perl(Perl/Critic/Violation.pm)
# Tests:
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Perl/Critic/TestUtils.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests
# CPAN::Meta not helpful
Requires:       perl(Perl/Critic/Violation.pm)

# Filter underspecified dependencies

Source44: import.info
%filter_from_requires /^perl(Test.More.pm)/d

%description
The Perl-Critic-Tics distribution includes extra policies for Perl::Critic
to address a fairly random assortment of things that make me (rjbs) wince.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Test/More.pm) >= 0.960

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Perl-Critic-Tics-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%dir %{perl_vendor_privlib}/Perl
%dir %{perl_vendor_privlib}/Perl/Critic
%dir %{perl_vendor_privlib}/Perl/Critic/Policy
%{perl_vendor_privlib}/Perl/Critic/Policy/Tics
%{perl_vendor_privlib}/Perl/Critic/Tics.pm

%files tests
%{_libexecdir}/%{name}

%changelog
