Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Foo.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Perl/Critic/Utils.pm) perl(Test/Perl/Critic.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%bcond_without perl_Perl_Metrics_Simple_enables_optional_test

Name:           perl-Perl-Metrics-Simple
Version:        1.0.3
Release:        alt1_6
Summary:        Count packages, subs, lines, etc. of many files
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Perl-Metrics-Simple
Source0:        https://cpan.metacpan.org/authors/id/M/MA/MATISSE/Perl-Metrics-Simple-v%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(JSON/PP.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Pod/Usage.pm)
BuildRequires:  perl(PPI.pm)
BuildRequires:  perl(PPI/Document.pm)
BuildRequires:  perl(Readonly.pm)
BuildRequires:  perl(Statistics/Basic/Mean.pm)
BuildRequires:  perl(Statistics/Basic/Median.pm)
BuildRequires:  perl(Statistics/Basic/StdDev.pm)
# Recommended:
BuildRequires:  perl(Readonly/XS.pm)
# Tests:
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(lib.pm)
# Moose not used, t/test_files/Perl/Code/Analyze/Test/Moose.pm is not compiled
BuildRequires:  perl(Test/Compile.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_Perl_Metrics_Simple_enables_optional_test}
# Optional tests:
# Perl::Critic::Utils not used
# Test::Perl::Critic not used
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Requires:     perl(Readonly/XS.pm) >= 1.020

# Remove under-specified dependencies

# Remove unused dependenices

# Remove private modules


Source44: import.info
%filter_from_requires /^perl(Test.Compile.pm)/d
%filter_from_requires /^perl(Moose.pm)/d
%filter_from_requires /}\|^perl(Perl.Metrics.Simple.Test/d
%filter_from_provides /^perl(Perl.Metrics.Simple.Test/d

%description
Perl::Metrics::Simple provides just enough methods to run static analysis
of one or many Perl files and obtain a few metrics: packages, subroutines,
lines of code, and an approximation of cyclomatic (McCabe) complexity for
the subroutines and the "main" portion of the code.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Test/Compile.pm) >= 1.1.0

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Perl-Metrics-Simple-v%{version}
perl -MConfig -i -pe 's/^#!.*perl/$Config{startperl}/ if $. == 1' bin/countperl
for F in \
%if !%{with perl_Perl_Metrics_Simple_enables_optional_test}
    t/0901_pod.t \
    t/0902_pod_coverage.t \
%endif
    t/perlcritic.t; do
    rm "$F"
    perl -i -ne 'print $_ unless m{\A\Q'"$F"'\E}' MANIFEST
done
# Help generators to recognize Perl scripts
for F in t/*.t \
    t/test_files/{no_packages_nor_subs,package_no_subs.pl,subs_no_package.pl} \
    t/more_test_files/*.pl; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
# t/000_compile.t examines ./bin and ./lib. Do no create symlinks. They would
# spoil generated dependencies.
rm %{buildroot}%{_libexecdir}/%{name}/t/000_compile.t
rm %{buildroot}%{_libexecdir}/%{name}/t/0901_pod.t
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc Changes EXAMPLES README Todo
%{_bindir}/countperl
%dir %{perl_vendor_privlib}/Perl
%dir %{perl_vendor_privlib}/Perl/Metrics
%{perl_vendor_privlib}/Perl/Metrics/Simple
%{perl_vendor_privlib}/Perl/Metrics/Simple.pm
%{_mandir}/man1/countperl.*

%files tests
%{_libexecdir}/%{name}

%changelog
