# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/git perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Dump.pm) perl(Devel/CheckBin.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Spec/Unix.pm) perl(Getopt/Long.pm) perl(String/PerlIdentifier.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define module_name Perl5-TestEachCommit
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Test each commit in a pull request to Perl core
Group: Development/Perl
License: perl
URL: http://thenceforward.net/perl/modules/Perl5-TestEachCommit/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JK/JKEENAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This library is intended for use by people working to maintain the
Perl core distribution.

Commits to `blead', the main development branch in the Perl repository, are
most often done by pull requests.  Most such p.r.s consist of a single commit,
but commits of forty or eighty are not unknown.  A continuous integration
system (CI) ensures that each p.r. is configured, built and tested on
submission and on subsequent modifications.  That CI system, however, only
executes that cycle on the *final* commit in each p.r.  It cannot detect any
failure in a *non-final* commit.  This library provides a way to test each
commit in the p.r. to the same extent that the CI system tests the final
commit.

Why is this important?  Suppose that we have a pull request that consists of 5
commits.  In commit 3 the developer makes an error which causes make to
fail.  The developer notices that and corrects the error in commit 4.  Commit
5 configures, builds and tests satisfactorily, so the CI system gives the p.r.
as a whole a PASS.  The committer uses that PASS as the basis for approving a
merge of the branch into `blead'.

    Commit  Configure   Build       Test
    ------------------------------------
    1abcd       X         X           X
    2efab       X         X           X
    3cdef       X         0           -
    4dcba       X         X           X
    5fedc       X         X           X

If, for any reason (*e.g.,* bisection), some other developer in the future
needs to say git checkout 3cdef, they will discover that at that commit the
build was actually broken.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Todo README LICENSE Changes examples
%perl_vendor_privlib/P*

%changelog
