# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Error.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(Test/Unit.pm) perl(Test/Unit/Debug.pm) perl(Test/Unit/HarnessUnit.pm) perl(Test/Unit/TestCase.pm) perl(Test/Unit/TestRunner.pm) perl(Test/Unit/TestSuite.pm) perl(base.pm) perl(fields.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name PerlActor
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: A simple automated executable acceptance test framework for Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TJ/TJBYRNE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
PerlActor is a simple automated executable acceptance test framework
for Perl.  It can be used by Extreme Programming (XP) teams to rapidly
develop executable acceptance tests for their Perl code.

XP mandates that the Customer writes acceptance tests for the application
under development.  The acceptance tests, also known as customer tests,
demonstrate that application features are complete and that they work as
expected.  Ideally, the tests should be directly executable and
automated so that they can be run continuously, without manual effort.

PerlActor enables an XP Customer to write *executable* acceptance
tests as plain text files, using a very simple syntax. Each test consists
of a number of parameterized commands (one per line), which PerlActor
uses to exercise the application. PerlActor parses the test, invokes the
commands with any parameters, and reports the result. The developers provide
glue code to implement the commands required by the tests.

PerlActor allows tests to be grouped into suites so that related tests can be
run as a group.  The Customer can also just place test scripts in a directory
structure and have PerlActor find and execute them all.

The PerlActor approach to acceptance testing has a number of advantages:

1) As the application grows the team will gradually develop a
comprehensive set of Commands for testing the application.

2) The Customer, independent of the development team, can write and execute
new tests for the application at any time, using any of the existing 
Commands.

3) Existing tests may be changed by the Customer at any time, again
without developer help.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/run_tests.pl

%files
%doc README Changes TODO examples
%perl_vendor_privlib/P*

%changelog
