# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Devel/Declare.pm) perl(Devel/Declare/Context/Simple.pm) perl(Devel/StrictMode.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Keyword/Simple.pm) perl(Test/Modern.pm) perl(Text/Balanced.pm)
# END SourceDeps(oneline)
%define module_name PerlX-Assert
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.905
Release: alt1
Summary: yet another assertion keyword
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/PerlX-Assert

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PerlX::Assert is a framework for embedding assertions in Perl code.
Under normal circumstances, assertions are not checked; they are
optimized away at compile time.

However if, at compile time, any of the following environment variables
is true, assertions are checked, and if they fail, throw an exception.

=over

=item *

`PERL_STRICT'

=item *

`AUTHOR_TESTING'

=item *

`EXTENDED_TESTING'

=item *

`RELEASE_TESTING'

=back

That is, assertions will only typically be checked when the test suite
is being run on the authors' machine, or otherwise opted into.

The exact decision logic can be found in the Devel::StrictMode manpage.

You can also force assertions to be checked using:

   use PerlX::Assert -check;

There are four syntaxes for expressing assertions:

   assert EXPR;
   assert { BLOCK };
   assert "name", EXPR;
   assert "name" { BLOCK };

Assertions can be named, which is probably a good idea because this
module (and the rest of Moops) screws up Perl's reporting of line
numbers. Names must be a quoted string (single or double quotes, or
the `q' or `qq' quote-like operators); general expressions are not
supported because the Text::Balanced manpage is used to parse the assertion
name. An assertion is a statement, so must be followed by a semicolon
unless it's the last statement in a block.

PerlX::Assert was originally distributed as part of the Moops manpage, but was
fairly independent of the rest of it, and has been spun off as a
separate release, and backported to Perl 5.8.1.

Assertions that span multiple lines are very likely to cause problems
on versions of Perl prior to 5.12. If the `assert' keyword, the
entire name, and the start of the expression or block are all on the
same line, this should be sufficient.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README CREDITS COPYRIGHT Changes
%perl_vendor_privlib/P*

%changelog
