# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(ExtUtils/MakeMaker.pm) perl(Keyword/Simple.pm) perl(Test/More.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name PerlX-Define
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.101
Release: alt1
Summary: cute syntax for defining constants
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/PerlX-Define

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PerlX::Define is a yet another module for defining constants.

Differences from constant.pm:

=over

=item *

Cute syntax.

Like constant.pm, constants get defined at compile time, not run time.

=item *

Requires Perl 5.12 or above.

If you're lucky enough to be able to free yourself from the shackles of
supporting decade-old versions of Perl, PerlX::Define is your friend.

=item *

Only supports scalar constants.

List constants are rarely useful.

Your constant can of course be a reference to an array or hash, but this
module doesn't attempt to make the referred-to structure read only.

=item *

Doesn't try to handle some of the things constant.pm does like declaring
constants using fully-qualified names, or defining constants pointing at
magic scalars.

=back

Prior to version 0.100, PerlX::Define was bundled with the Moops manpage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE COPYRIGHT README Changes CREDITS
%perl_vendor_privlib/P*

%changelog
