%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Select.pm) perl(IO/Socket/INET.pm) perl(Log/Syslog/Constants.pm) perl(Log/Syslog/DangaSocket.pm) perl(Log/Syslog/Fast.pm) perl(Perlbal.pm) perl(Perlbal/Test.pm) perl(Perlbal/Test/WebClient.pm) perl(Sys/Hostname.pm) perl(Test/More.pm) perl(Tie/Handle.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name Perlbal-Plugin-Syslogger
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Perlbal plugin that adds low-impact syslog
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AT/ATHOMASON/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
# plugin
    package Perlbal::Plugin::MyPlugin;

    use Perlbal::Plugin::Syslogger 'send_syslog_msg';

    sub register {
        my ($class, $svc) = @_;

        # explicit mode
        send_syslog_msg($svc, 'Registering MyPlugin');
        $svc->register_hook('MyPlugin', 'start_http_request' => sub {
            send_syslog_msg($svc, 'Handling request in MyPlugin');
        });

        # implicit mode
        Perlbal::Plugin::Syslogger::replace_perlbal_log($svc);
        Perlbal::log(info => "log message");
    }

    # perlbal config
    CREATE SERVICE fakeproxy
        SET role            = reverse_proxy
        SET listen          = 127.0.0.1:8080

        # set these after role/listen and before plugins
        SET syslog_host     = log-host
        SET syslog_port     = 514
        SET syslog_source   = perlbal-host
        SET syslog_name     = perlbal
        SET syslog_facility = 21
        SET syslog_severity = 5

        SET plugins         = Syslogger, MyPlugin
    ENABLE fakeproxy


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
