# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Math/Project3D/Plot.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Physics-Particles
%define upstream_version 1.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Simulate particle dynamics
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Physics/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Module/Build/Compat.pm)
BuildArch: noarch
Source44: import.info

%description
Physics::Particles is a facility to simulate movements of a small number of
particles under a small number of forces that every particle exerts on the
others. Complexity increases with particles X particles X forces, so that
is why the number of particles should be low.

In the context of this module, a particle is no more or less than a set of
attributes like position, velocity, mass, and charge. The example code and
test cases that come with the distribution simulate the inner solar system
showing that when your scale is large enough, planets and stars may well be
approximated as particles. (As a matter of fact, in the case of gravity, if
the planet's shape was a sphere, the force of gravity outside the planet
would always be its mass times the mass of the body it exerts the force on
times the gravitational constant divided by the distance squared.)

Simulation of microscopic particles is a bit more difficult due to floating
point arithmetics on extremely small values. You will need to choose your
constant factors wisely.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc META.yml Changes README SIGNATURE
%perl_vendor_privlib/*




%changelog
