%define module_version 0.06
%define module_name Plack-App-CGIBin-Streaming
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(CGI.pm) perl(CGI/Compile.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Module/Build/Tiny.pm) perl(PerlIO/via.pm) perl(Plack.pm) perl(Plack/App/File.pm) perl(Plack/Handler/Starman.pm) perl(Plack/Test.pm) perl(Plack/Util/Accessor.pm) perl(Starman.pm) perl(Starman/Server.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Tie/Handle.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: allow old style CGI applications to use the plack streaming protocol
Group: Development/Perl
License: artistic_2
URL: https://github.com/binary-com/perl-Plack-App-CGIBin-Streaming

Source0: http://cpan.org.ua/authors/id/O/OP/OPI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
With the Plack manpage already comes the Plack::App::CGIBin manpage.
`Plack::App::CGIBin::Streaming' serves a very similar purpose.

So, why do I need another module? The reason is that the Plack::App::CGIBin manpage
first collects all the output from your CGI scripts before it prints the
first byte to the client. This renders the following simple clock script
useless:

 use strict;
 use warnings;

 $|=0;

 my $boundary='The Final Frontier';
 print <<"EOF";
 Status: 200
 Content-Type: multipart/x-mixed-replace;boundary="$boundary";

 EOF

 $boundary="--$boundary\n";

 my $mpheader=<<'HEADER';
 Content-type: text/html; charset=UTF-8;

 HEADER

 for(1..100) {
     print ($boundary, $mpheader,
            '<html><body><h1>'.localtime()."</h1></body></html>\n");
     $|=1; $|=0;
     sleep 1;
 }

 print ($boundary);

Although multipart HTTP messages are quite exotic, there are situations
where you rather want to prevent this buffering. If your document is very
large for example, each instance of your plack server allocates the RAM
to buffer it. Also, you might perhaps send out the `<head>' section
of your HTTP document as fast as possible to enable the browser load JS and
CSS while the plack server is still busy with producing the actual document.

`Plack::App::CGIBin::Streaming' compiles the CGI scripts using
the CGI::Compile manpage and provides a runtime environment similar to
`Plack::App::CGIBin'. Compiled scripts are cached. For production
environments, it is possible to precompile and cache scripts at server
start time, see the `preload' option below.

Every single request is represented as an object that inherits from
the Plack::App::CGIBin::Streaming::Request manpage. This class mainly provides
means for handling response headers and body.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/P*

%changelog
