# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(HTTP/Request/Common.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Plack-Middleware-Cached
%define upstream_version 0.15

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    Glues a cache to your PSGI application
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Plack/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Clone.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Plack/Builder.pm)
BuildRequires: perl(Plack/Middleware.pm)
BuildRequires: perl(Plack/Util/Accessor.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(overload.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(utf8.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module can be used to glue a cache to a PSGI applications
or middleware. A *cache* is an object that provides at least two methods to
get and set data, based on a key. Existing cache modules on CPAN include
CHI, Cache  and Cache::Cache.
Plack::Middleware::Cached is put in front of a PSGI application as
middleware. Given a request in form of a PSGI environment E, it either
returns the matching response R from its cache, or it passed the request to
the wrapped application, and stores the application's response in the
cache:

                      ________          _____
    Request  ===E===>|        |---E--->|     |
                     | Cached |        | App |
    Response <==R====|________|<--R----|_____|

In most cases, only a part of the environment E is relevant to the request.
This relevant part is called the caching *key*. By default, the key is set
to the value of REQUEST_URI from the environment E.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc LICENSE META.yml  README
%perl_vendor_privlib/*


%changelog
