# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/QueryLog.pm) perl(DBIx/Class/QueryLog/Analyzer.pm) perl(DBIx/Class/ResultSet.pm) perl(DBIx/Class/Schema.pm) perl(Data/Dump.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(Getopt/Long.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Manifest/Skip.pm) perl(Moo.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Plack.pm) perl(Plack/Builder.pm) perl(Plack/Middleware/DBIC/QueryLog.pm) perl(Plack/Middleware/Debug.pm) perl(Plack/Test.pm) perl(Pod/ParseLink.pm) perl(Pod/Parser.pm) perl(Pod/Usage.pm) perl(SQL/Abstract.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Text/MicroTemplate.pm) perl(UUID/Tiny.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Plack-Middleware-Debug-DBIC-QueryLog
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: DBIC Query Log and Query Analyzer
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/Plack-Middleware-Debug-DBIC-QueryLog/

Source0: http://cpan.org.ua/authors/id/J/JJ/JJNAPIORK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
the DBIx::Class::QueryLog manpage is a tool in the the DBIx::Class manpage software ecosystem
which benchmarks queries.  It lets you log the SQL that the DBIx::Class manpage
is generating, along with bind variables and timestamps.  You can then pass
the querylog object to an analyzer (such as the DBIx::Class::QueryLog::Analyzer manpage)
to generate sorted statistics for all the queries between certain log points.

Query logging in the Catalyst manpage is supported for the DBIx::Class manpage via a trait for
the Catalyst::Model::DBIC::Schema manpage called
the Catalyst::TraitFor::Model::DBIC::Schema::QueryLog manpage.  This trait will
log all the SQL used by the DBIx::Class manpage for a given request cycle.  This is very
useful since it can help you identify troublesome or bottlenecking queries.

However, the Catalyst::TraitFor::Model::DBIC::Schema::QueryLog manpage does not provide
out of the box outputting of your analyzed query logs.  Usually you need to
add a bit of templating work to the bottom of your webpage footer, or dump the
output to the logs.  We'd like to provide a lower ceremony experience.

Additionally, it would be nice if we could provide this functionality for all
the Plack manpage based applications, not just the Catalyst manpage.  Ideally we'd play nice with
the Plack::Middleware::Debug manpage so that the table of our querylog would appear as
a neat Plack based Debug panel.  This bit of middleware provides that function.

Basically we create a new instance of the DBIx::Class::QueryLog manpage and place it
into `$env->{'plack.middleware.dbic.querylog'}' (We use the underlying
features in the Plack::Middleware::DBIC::QueryLog manpage) so that it is accessible by
all applications running inside of the Plack manpage.  You need to 'tell' your application's
instance of the DBIx::Class manpage to use this `$env' key and make sure you set
the DBIx::Class manpage's debug object correctly.  The officially supported interface for
this in via the supporting class the Plack::Middleware::DBIC::QueryLog manpage:

    use Plack::Middleware::DBIC::QueryLog;

    my $querylog = Plack::Middleware::DBIC::QueryLog->get_querylog_from_env($env);
    my $cloned_schema = $schema->clone;
    $cloned_schema->storage->debug(1);
    $cloned_schema->storage->debugobj($querylog);

In this example `$env' is a the Plack manpage environment, typically passed into your PSGI
compliant application and `$schema' is an instance of the DBIx::Class::Schema manpage

We clone `$schema' to avoid associating the querylog with the global, persistant
DBIC schema object.

Then you need to enable the Debug panel, as in the the section on "\SYNOPSIS".  That way when
you view the debug panel, we have SQL to review.

There's an application in '/example' you can review for help.  However, if you
are using the Catalyst manpage and a modern the Catalyst::Model::DBIC::Schema manpage you can use
the trait the Catalyst::TraitFor::Model::DBIC::Schema::QueryLog::AdoptPlack manpage,
which is compatible with the Catalyst::TraitFor::Model::DBIC::Schema::QueryLog manpage.

If you want a querylog but don't want or need the the Plack manpage debug panel, you
should take a look at the Plack::Middleware::DBIC::QueryLog manpage.

See the the SYNOPSIS entry elsewhere in this document example for more details.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn Changes example
%perl_vendor_privlib/P*

%changelog
