%define module_version 0.002
%define module_name Plack-Middleware-GepokX-ModSSL
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/X509.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(Gepok.pm) perl(MIME/Base64.pm) perl(Net/SSL.pm) perl(Net/SSLeay.pm) perl(Plack.pm) perl(Plack/Util/Accessor.pm) perl(Test/More.pm) perl(base.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: roughly compatible with Plack::Middleware::Apache2::ModSSL
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Plack-Middleware-GepokX-ModSSL

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This middleware attempts to recreate for Gepok, some
of the SSL information which Apache's mod_ssl would
put into the Plack `$env' hashref.

It supports the following variables, as defined by
http://httpd.apache.org/docs/2.0/mod/mod_ssl.html.

=over

=item * `SSL_CIPHER'

=item * `SSL_CIPHER_USEKEYSIZE'

=item * `SSL_CLIENT_CERT'

=item * `SSL_CLIENT_I_DN'

=item * `SSL_CLIENT_I_DN_C'

=item * `SSL_CLIENT_I_DN_CN'

=item * `SSL_CLIENT_I_DN_Email'

=item * `SSL_CLIENT_I_DN_L'

=item * `SSL_CLIENT_I_DN_O'

=item * `SSL_CLIENT_I_DN_ST'

=item * `SSL_CLIENT_M_SERIAL'

=item * `SSL_CLIENT_M_VERSION'

=item * `SSL_CLIENT_S_DN'

=item * `SSL_CLIENT_S_DN_C'

=item * `SSL_CLIENT_S_DN_CN'

=item * `SSL_CLIENT_S_DN_Email'

=item * `SSL_CLIENT_S_DN_L'

=item * `SSL_CLIENT_S_DN_O'

=item * `SSL_CLIENT_S_DN_ST'

=item * `SSL_CLIENT_VERIFY'

=item * `SSL_CLIENT_V_END'

=item * `SSL_CLIENT_V_START'

=item * `SSL_PROTOCOL'

=back

Nothing is done by default. You need to tell the module which
variables you want:

 builder
 {
     enable "GepokX::ModSSL",
         vars => [qw( SSL_CIPHER SSL_CIPHER_USEKEYSIZE )];
     $app;
 };

If you want it all, then:

 builder
 {
     enable "GepokX::ModSSL",
         vars => [ Plack::Middleware::GepokX::ModSSL->all ];
     $app;
 };

Though bear in mind that some variables are more computationally
expensive than others. Cheap ones are: `SSL_PROTOCOL', `SSL_CIPHER',
`SSL_CIPHER_USEKEYSIZE', `SSL_CLIENT_CERT', `SSL_CLIENT_VERIFY'.

=begin private

=item call

=item all

=end private


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYRIGHT Changes LICENSE examples
%perl_vendor_privlib/P*

%changelog
