# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Pod.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Plack-Middleware-Negotiate
%define upstream_version 0.20

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Apply HTTP content negotiation as Plack middleware
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Plack/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(HTTP/Negotiate.pm)
BuildRequires: perl(HTTP/Request/Common.pm)
BuildRequires: perl(Log/Contextual.pm)
BuildRequires: perl(Log/Contextual/WarnLogger.pm)
BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Plack/Builder.pm)
BuildRequires: perl(Plack/Middleware.pm)
BuildRequires: perl(Plack/Request.pm)
BuildRequires: perl(Plack/Test.pm)
BuildRequires: perl(Plack/Util/Accessor.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Plack::Middleware::Negotiate applies HTTP content negotiation to a the PSGI
manpage request. The PSGI environment key 'negotiate.format' is set to the
chosen format name. In addition to normal content negotiation one may
enable explicit format selection with a path extension or query parameter.
The middleware takes care for rewriting and restoring PATH_INFO if it is
configured to detect and strip a format extension. The PSGI response is
enriched with corresponding HTTP headers Content-Type and Content-Language
unless these headers already exist.

If used as pure application, this middleware returns a HTTP status code 406
if no format could be negotiated.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor

./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc LICENSE META.yml  README
%{perl_vendor_privlib}/*


%changelog
