%define module_name Plack-Middleware-PrettyException
# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTTP/Headers.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Status.pm) perl(HTTP/Throwable/Factory.pm) perl(JSON/MaybeXS.pm) perl(Log/Any.pm) perl(Module/Build.pm) perl(MooX/StrictConstructor.pm) perl(Plack/Builder.pm) perl(Plack/Middleware.pm) perl(Plack/Test.pm) perl(Plack/Util.pm) perl(Plack/Util/Accessor.pm) perl(Throwable.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.010
Release: alt1
Summary: Capture exceptions and present them as HTML or JSON
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DOMM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Plack::Middleware::PrettyException' allows you to use exceptions in
your models (and also controllers, but they should be kept slim!) and
have them rendered as JSON or nice-ish HTML with very little fuzz.

But if your Plack app returns an HTTP status code indicating an error
(4xx/5xx) or just dies somewhere, the client also sees a pretty
exception.

So instead of capturing exceptions in your controller actions and
converting them to proper error messages, you just let the exception
propagate up to this middleware, which will then to the rendering.
This leads to much cleaner code in your controller, and to proper
exception usage in your model.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/P*

%changelog
