# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(EV.pm) perl(Event.pm) perl(Glib.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Plack-Test-AnyEvent
%define upstream_version 0.08

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Run Plack::Test on AnyEvent-based PSGI applications
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Plack/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(AnyEvent.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(HTTP/Message/PSGI.pm)
BuildRequires: perl(HTTP/Request.pm)
BuildRequires: perl(HTTP/Request/Common.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Plack.pm)
BuildRequires: perl(Test/Class.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(autodie.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
# Private requires:
%global __requires_exclude %{?__requires_exclude:%__requires_exclude|}^perl\\(Plack::Test::AnyEvent::Response\\)
Source44: import.info

%description
This L<Plack::Test> implementation allows you to easily test your
L<AnyEvent>-based PSGI applications. Normally, L<Plack::Test::MockHTTP> or
L<Plack::Test::Server> work fine for this, but this implementation comes in
handy when you'd like to test your streaming results as they come in, or if
your application uses long-polling. For non-streaming requests, you can use
this module exactly like Plack::Test::MockHTTP; otherwise, you can set up a
content handler and call C<$res-E<gt>recv>. The event loop will then run
until the PSGI application closes its writer handle or until your test
client calls C<send> on the response.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor

./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*


%changelog
