# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(Capture/Tiny.pm) perl(Config.pm) perl(Cwd.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(IO/All.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Manifest/Skip.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Markdown.pm) perl(Pod/Perldoc.pm) perl(Socket.pm) perl(YAML/Tiny.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Pod-Cpandoc
%define upstream_version 0.16

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    Perldoc that works for modules you don't have installed
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Pod/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(HTTP/Tiny.pm)
BuildRequires: perl(IO/Socket/SSL.pm)
BuildRequires: perl(JSON/PP.pm)
BuildRequires: perl(Net/SSLeay.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildArch:  noarch
Source44: import.info

%description
'cpandoc' is a perl script that acts like 'perldoc' except that if it would
have bailed out with 'No documentation found for "Uninstalled::Module"', it
will instead scrape a CPAN index for the module's documentation.

One important feature of 'cpandoc' is that it _only_ scrapes the live index
if you do not have the module installed. So if you use 'cpandoc' on a
module you already have installed, then it will just read the
already-installed documentation. This means that the version of the
documentation matches up with the version of the code you have. As a fringe
benefit, 'cpandoc' will be fast for modules you've installed. :)

All this means that you should be able to drop in 'cpandoc' in place of
'perldoc' and have everything keep working. See the /SNEAKY INSTALL manpage
for how to do this.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml  README
%{perl_vendor_privlib}/*
/usr/bin/cpandoc
%{_mandir}/man1/cpandoc.1*


%changelog
