%define module_name Pod-Elemental-Transformer-Splint
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(List/UtilsBy.pm) perl(Module/Load.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/AttributeDocumented.pm) perl(Path/Tiny.pm) perl(Pod/Elemental.pm) perl(Pod/Elemental/Transformer.pm) perl(Pod/Elemental/Transformer/Pod5.pm) perl(Pod/Simple/XHTML.pm) perl(Ref/Util.pm) perl(Safe/Isa.pm) perl(Syntax/Feature/Qs.pm) perl(Test/Differences.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(Try/Tiny.pm) perl(Types/Standard.pm) perl(namespace/autoclean.pm) perl(syntax.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1202
Release: alt1
Summary: Documentation from class metadata
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Pod-Elemental-Transformer-Splint

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CS/CSSON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Pod::Elemental::Transformer::Splint uses the MooseX::AttributeDocumented manpage to add inlined documentation about attributes to pod.
If you write your classes with the Moops manpage you can also document method signatures with the Kavorka::TraitFor::Parameter::doc manpage (and ::ReturnType::doc).

A class defined like this:

    package My::Class;

    use Moose;

    has has_brakes => (
        is => 'ro',
        isa => Bool,
        default => 1,
        traits => ['Documented'],
        documentation => 'Does the bike have brakes?',
        documentation_alts => {
            0 => 'Hopefully a track bike',
            1 => 'Always nice to have',
        },
    );

    =pod

    :splint classname My::Class

    :splint attributes

    
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/P*

%changelog
