%define module_name Pod-Multi
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Save/Home.pm) perl(File/Spec.pm) perl(IO/Capture.pm) perl(Pod/Html.pm) perl(Pod/Man.pm) perl(Pod/Text.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: pod2man, pod2text, pod2html simultaneously
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JK/JKEENAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
When you install a Perl module from CPAN, documentation gets installed which
is readable with perldoc and (at least on *nix-like systems) with man as
well.  You can convert that documentation to text and HTML formats with two
utilities that come along with Perl:  pod2text and pod2html.

In production environments documentation of Perl *programs* tends to be less
rigorous than that of CPAN modules.  If you want to convince your co-workers
of the value of writing documentation for such programs, you may want a
painless way to generate that documentation in a variety of formats.  If you
already know how to write documentation in Perl's Plain Old Documentation
(POD) format, Pod::Multi will save you some keystrokes by simultaneously 
generating documentation in manpage, plain-text and HTML formats from a 
source file containing POD.

In its current version, Pod::Multi generates those documentary files in the same
directory as the source file.  It does not attempt to install those files
anywhere else.  In particular, it does not attempt to install the manpage
version in a MANPATH directory.  This may change in a future version, but for
the time being, we're keeping it simple.

Pod::Multi is intended to be used primarily via its associated command-line
utility, pod2multi.  pod2multi requires only one argument:  the path to
a file containing documentation in POD format.  In the interest of simplicity,
any other arguments provided on the command-line are concatenated into a
wordspace-separated string which will serve as the title tag of the HTML
version of the documentation.  No other options are offered because, in the
author's opinion, if you want more options you'll probably use as many
keystrokes as you would if you ran pod2man, pod2text or pod2html
individually. 

The functional interface may be used inside Perl
programs and, if you have personal preferences for the options you would
normally provide to pod2man, pod2text or pod2html, you can specify
them in the functional interface.  If you have a strong set of personal
preferences as to how you like your text, manpage and HTML versions of your 
POD to look, you can even save them with the `make_options_defaults()'
function, which stores those options in a .pod2multirc file in an
appropriate place underneath your home directory.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/P*

%files scripts
%_bindir/*

%changelog
