%define module_name Pod-Term
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(Hash/Merge.pm) perl(Pod/Simple.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Yet another POD Parser for terminal (ie command line) output
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMGRACEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Despite the plethora of Pod parsing modules on CPAN I couldn't seem to coax any into meeting my presentation requirements for pod printed at the terminal. I never anticipated getting diverted onto writing a full-blown POD parser, but that is what ended up happening. My advice to anyone considering writing a POD parser - don't go there. Quantum mechanics is much less troublesome.

This is yet another POD parser. It inherits from the POD::Simple manpage and so all the Pod::Simple manpage methods *should* be available (but Pod::Simple seems pretty complex under the hood and possibly in need of some maintenance. I am wondering if the advice to 'use Pod::Simple for all things Pod' is really the best? e.g. I was not able to get the `output_string' method to work at all).

Like the Pod::Text::Color manpage, the Pod::Term manpage uses the Term::ANSIColor manpage to set ANSI color values to POD elements. However I was not able to get the Pod::Text::Color manpage to cleanly wrap colored text. It seems that the Pod::Text::Color manpage attempts to wrap the text *after* putting in the color characters, by trying to ignore those characters - I am not sure if it is the reason. I also couldn't seem to control the spacing, indents etc.

the Pod::Term manpage wraps text before inserting color values, and should produce a nice clean wrap. It also offers a decent level of control over formatting, by allowing you to assign simple directives (`indent', `top_spacing' etc.) to individual page elements (`head1', `over' etc.) POD has never looked so good!

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
