# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Pod-Weaver-Section-SeeAlso
%define upstream_version 1.003

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Add a SEE ALSO pod section
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Pod/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Autobox.pm)
BuildRequires: perl(Pod/Weaver/Role/Section.pm)
BuildRequires: perl(Test/More.pm)
BuildArch: noarch
Source44: import.info

%description
This section plugin will produce a hunk of pod that references the main
module of a dist from it's submodules and adds any other text already
present in the pod. It will do this only if it is being built with the
Dist::Zilla manpage because it needs the data from the dzil object.

In the main module, this section plugin just transforms the links into a
proper list. In the submodules, it also adds the link to the main module.

For an example of what the hunk looks like, look at the the /SEE ALSO
manpage section in this POD :)

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README Changes LICENSE META.yml META.json
%perl_vendor_privlib/*




%changelog
