# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Pod-Weaver-Section-Support
%define upstream_version 1.014

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Add a SUPPORT section to your POD
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Pod/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(PPIx/DocumentName.pm)
BuildRequires: perl(Pod/Weaver/Role/Section.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This section plugin will produce a hunk of pod that lists the various ways
to get support for this module. It will do this only if it is being built
with the Dist::Zilla manpage because it needs the data from the dzil
object.

If you have the Dist::Zilla::Plugin::Repository manpage enabled in your
_dist.ini_, be sure to check the repository_link attribute!

This is added *ONLY* to the main module's POD, because it would be a waste
of space to add it to all modules in the dist.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README examples
%perl_vendor_privlib/*

%changelog
