# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Pod-WikiDoc
%define upstream_version 0.21

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Examples of Pod::WikiDoc usage
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Pod/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Cwd.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(File/pushd.pm)
BuildRequires: perl(Getopt/Lucid.pm)
BuildRequires: perl(IO/File.pm)
BuildRequires: perl(IO/String.pm)
BuildRequires: perl(IPC/Run3.pm)
BuildRequires: perl(Parse/RecDescent.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Probe/Perl.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/Builder.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Text/Balanced.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(vars.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Pod works well, but writing it can be time-consuming and tedious. For
example, commonly used layouts like lists require numerous lines of text to
make just a couple of simple points. An alternative approach is to write
documentation in a wiki-text shorthand (referred to here as _wikidoc_) and
use Pod::WikiDoc to extract it and convert it into its corresponding Pod as
a separate '.pod' file.

Documentation written in wikidoc may be embedded in Pod format blocks, or,
optionally, in specially marked comment blocks. Wikidoc uses simple
text-based markup like wiki websites to indicate formatting and links. (See
the /WIKIDOC MARKUP manpage, below.)

Pod::WikiDoc processes text files (or text strings) by extracting both
existing Pod and wikidoc, converting the wikidoc to Pod, and then writing
the combined document back to a file or standard output.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README examples
%{_bindir}/*
%{_mandir}/man1/*
%{perl_vendor_privlib}/*

%changelog
