%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Spiffy.pm) perl(Test/More.pm) perl(YAML.pm) perl(inc/Module/Install.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Pointer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Object Oriented Memory Pointers in Pure Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IN/INGY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module allows you to create Perl objects that emulate C pointers.
You can use them to read and explore the memory of your Perl process.

Pointer.pm (and every subclass) exports a function called `pointer'
that returns a new pointer object. Each object has a type like (void,
int, long, sv). Support for each pointer type is written as a subclass
of Pointer.pm. Pointer.pm itself is for type `void'. To create a
pointer to a long integer, do:

    use Pointer::long;
    my $p = pointer('long');

Your new pointer is not pointing to anything yet. One way to put an
address into the pointer is directly, like this:

    $p->to(0x123456);

Another way is to point it at an existing scalar like this:

    $p->of_scalar($foo);

Both of these methods return the pointer so that you can chain other
methods onto them:

    my $int = $p->of_scalar($foo)->get;

The `get' method returns whatever the pointer points to. Since `$p' is
an integer pointer, this call returns an integer. The `get' method
takes an optional number as an argument, which indicates the number of
values to get.

Pointer pointers honor pointer arithmetic. If you add or subtract a
number to a pointer, the result is another pointer. As in C pointer
arithmetic, the number of bytes added to the address depends on the size
of the type represented by the pointer.

    my $p1 = pointer('long')->of_scalar($foo);
    my $p2 = $p1 - 5;

is the same as:

    my $p1 = pointer('long')->of_scalar($foo);
    my $p2 = pointer('long')->address($p1->address - 5 * $p1->sizeof);


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
