%define module_name Poker-Eval
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Combinatorics.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Moo.pm) perl(Storable.pm) perl(Test/More.pm) perl(Tie/IxHash.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Deal, score, and calculate expected win rates of poker hands. Base class for specific game types. 
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NG/NGRAHAM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is just a base class. Poker::Eval::Omaha shows a real example.

    use Poker::Eval::Omaha; # Omaha style rules
    use Poker::Score::High; # Highball scoring system
    use feature qw(say);

    # Object to represent a typical post flop situation
    my $ev = Poker::Eval::Omaha->new(
      scorer => Poker::Score::High->new,
      hole_remaining => 0, # hole cards already dealt
      community_remaining => 2, # turn and river yet to come
    );

    # shuffle deck
    $ev->dealer->shuffle_deck;

    # deal three community cards (post flop) 
    $ev->community_cards( $ev->deal_named(['5c','9h','Ks']));

    # deal and score three separate hands 
    my $hand1 = $ev->best_hand($ev->deal_named(['Ts','Js','3d','4d']));
    my $hand2 = $ev->best_hand($ev->deal_named(['5h','5s','6s','7s']));
    my $hand3 = $ev->best_hand($ev->deal(4)); # random cards

    # best combination (hole + community) in human-readable form
    say $hand1->best_combo_flat;

    # english name of best combination (e.g. 'Two Pair')
    say $hand1->name;

    # numerical score of best combination
    say $hand1->score;

    # hole cards in human-readable form
    say $hand1->cards_flat;

    # calculate expected win rate of each hand
    $ev->calc_ev([$hand1, $hand2, $hand3]);

    # expected win rate of each hand (as percent)
    say $hand1->ev; say $hand2->ev; say $hand3->ev;

    # hands 1, 2 and 3 win 13, 76, and 11 percent of the time respectively.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
