# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Polycom-App-Push
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Module for writing web applications for Polycom VoIP phones
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZB/ZBLAIR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The `Polycom::App::Push' class is for writing web applications for Polycom's SoundPoint IP and VVX series VoIP phones. It provides a mechanism to push messages to a phone for display to the user.

Note that to use the `push_message' method, the phone must be configured with the following parameters, where the values of each parameters should be customized based on your requirements:

   <apps
     apps.push.messageType="5"
     apps.push.serverRootURL="http://192.168.1.11"
     apps.push.username="Polycom"
     apps.push.password="456" />

The value of the '`apps.push.messageType'' parameter is very important, because it determines how the phone will filter incoming push messages based on their '`priority'' attributes. The allowable values for the '`apps.push.messageType'' parameter are: 

   0 - Don't show any push messages
   1 - Show messages with 'priority="normal"'
   2 - Show messages with 'priority="important"'
   3 - Show messages with 'priority="high"'
   4 - Show messages with 'priority="critical"'
   5 - Show all messages, regardless of their 'priority' value

The '`apps.push.serverRootURL'' parameter is used as the base URL for the relative URL passed to '`push_message'' method in its '`url'' parameter.

The '`apps.push.username'' and '`apps.push.password'' parameters must match the '`username'' and '`password'' parameters passed to the '`push_message'' method.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
