# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/File.pm) perl(Test/More.pm) perl(XML/Twig.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Polycom-Config-File
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Parser for Polycom VoIP phone config files.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZB/ZBLAIR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module can be used to read, modify, or create config files for Polycom's SoundPoint IP, SoundStation IP, and VVX series of VoIP phones.

Configuration files enable administrators to configure phone parameters ranging from line registrations, to preferred codecs, to background images.

The files are structured using XML, where each attribute is named after a configuration parameter. For instance, the XML below would constitute a valid configuration file that specifies a SIP registration server and a dial plan digit map.

  <?xml version="1.0" standalone="yes"?>
  <localcfg>
     <server voIpProt.server.1.address="test.example.com"/>
     <digitmap
  dialplan.digitmap="[2-9]11|0T|011xxx.T|[0-1][2-9]xxxxxxxxx|604xxxxxxx|
  778xxxxxxx|[2-4]xxx"/>
  </localcfg>

For more information about managing configuration files on Polycom SoundPoint IP, SoundStation IP, or VVX VoIP phones, see the "*Configuration File Management on Polycom SoundPoint IP Phones*" document at http://www.polycom.com/global/documents/whitepapers/configuration_file_management_on_soundpoint_ip_phones.pdf.

For a detailed list of available configuration parameters, consult the "*SoundPoint IP, SoundStation IP and Polycom VVX Administrator's Guide*" document at http://www.polycom.com/global/documents/support/setup_maintenance/products/voice/spip_ssip_vvx_Admin_Guide_SIP_3_2_2_eng.pdf.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/P*

%changelog
