%define module_version 1.05
%define module_name Prancer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/Any.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers/Fast.pm) perl(HTTP/Request/Common.pm) perl(Hash/MultiValue.pm) perl(Module/Load.pm) perl(Plack/Middleware/Session.pm) perl(Plack/Middleware/Static.pm) perl(Plack/Request.pm) perl(Plack/Response.pm) perl(Plack/Session/State/Cookie.pm) perl(Plack/Session/Store.pm) perl(Plack/Session/Store/File.pm) perl(Plack/Test.pm) perl(Storable.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Try/Tiny.pm) perl(URI/Escape.pm) perl(Web/Simple.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: >new("/path/to/foobar.yml")->to_psgi_app();
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PL/PLOCKABY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Prancer is yet another PSGI framework that provides routing and session
management as well as plugins for logging, database access, and template
engines. It does this by wrapping the Web::Simple manpage to handle routing and by
wrapping other libraries to bring easy access to things that need to be done in
web applications.

There are two parts to using Prancer for a web application: a package to
contain your application and a script to call your application. Both are
necessary.

The package containing your application should contain a line like this:

    use Prancer;

This modifies your application package such that it inherits from Prancer. It
also means that your package must implement the `handler' method and
optionally implement the `initialize' method. As Prancer inherits from
Web::Simple it will also automatically enable the `strict' and `warnings'
pragmas.

As mentioned, putting `use Prancer;' at the top of your package will require
you to implement the `handler' method, like this:

    sub handler {
        my ($self, $env, $request, $response, $session) = @_;

        # routing goes in here.
        # see Web::Simple for documentation on writing routing rules.
        sub (GET + /) {
            $response->header("Content-Type" => "text/plain");
            $response->body("Hello, world!");
            return $response->finalize(200);
        }
    }

The `$request' variable is a the Prancer::Request manpage object. The `$response'
variable is a the Prancer::Response manpage object. The `$session' variable is a
the Prancer::Session manpage object. If there is no configuration for sessions in any of
your configuration files then `$session' will be `undef'.

You may implement your own `new' method in your application but you MUST
call `$class->SUPER::new(@_);' to get the configuration file loaded and
any methods exported. As an alternative to implemeting `new' and remembering
to call `SUPER::new', Prancer will make a call to `->initialize' at the
end of its own implementation of `new' so things that you might put in `new'
can instead be put into `initialize', like this:

    sub initialize {
        my $self = shift;

        # this is where you can initialize things when your package is created

        return;
    }

By default, Prancer does not export anything into your package's namespace.
However, that doesn't mean that there is not anything that it *could* export
were one to ask:

    use Prancer qw(config);

Importing `config' will make the keyword `config' available which gives
access to any configuration options loaded by Prancer.

The second part of the Prancer equation is the script that creates and calls
your package. This can be a pretty small and standard little script, like this:

    my $myapp = MyApp->new("/path/to/foobar.yml")
    my $psgi = $myapp->to_psgi_app();

`$myapp' is just an instance of your package. You can pass to `new' either
one specific configuration file or a directory containing lots of configuration
files. The functionality is documented in `Prancer::Config'.

`$psgi' is just a PSGI app that you can send to the Plack::Runner manpage or whatever
you use to run PSGI apps. You can also wrap middleware around `$app'.

    my $psgi = $myapp->to_psgi_app();
    $psgi = Plack::Middleware::Runtime->wrap($psgi);
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes examples
%perl_vendor_privlib/P*

%changelog
