# BEGIN SourceDeps(oneline):
BuildRequires: /proc perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Proc-Info-Environment
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Read Environment Variables of any Process
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHILLI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Proc::Info::Environment retrieves the settings of environment variables
in arbitrary running processes of the operating system.

For example,

    use Proc::Info::Environment;
    my $proc_env = Proc::Info::Environment->new();
    my $env = $proc_env->env( 123 );

will retrieve the environment settings of the process with the pid 123 
and (if this process exists and is readable by the user) return them as a 
hash reference in $env. 

As an illustrative (but not very useful) example, retrieving

    my $env = $proc_env->env( $$ );

will return a reference to a hash similar to `%%ENV', which contains the
environment variables of the current process.

Reading other processes' environment variables is only possible 
if the operating system (a) supports a method to do this and (b)
the user of the currently running process is either root, or has the 
same uid as the process whose variables it wants to read.

Proc::Info::Environment is currently supported only for specific Unix
systems. On Linux, it will use the procfs file system mounted under /proc
to get the information needed. It will read the file /proc/xxx/environ, 
where xxx is the pid of the target process.

To verify if Proc::Info::Environment supports your operating system, 
run Proc::Info::Environment::os_supported(), which returns a true value
if it is supported. If the OS is unsupported, the new() constructor will
die() with an error message listing all currently supported operating 
systems.

The module's architecture allows for easy support of other systems, if
you want support for one and know how the information is provided,
drop me an email.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
