# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(Test.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.16
%define module_name Proc-Reliable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.16
Release: alt1
Summary: - Run external processes reliably with many options.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DG/DGOLD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
A new process object is created by.
   $myproc = Proc::Reliable->new();

The default will run a subprocess only once with a 60-second timeout.
Either shell-like command lines or references 
to perl subroutines can be specified for launching a process in 
background.  A simple list process, for example, can be started 
via the shell as

   $out = $myproc->run("ls");

To separate stdout, stderr, and exit status:

   ($out, $err, $status, $msg) = $myproc->run("ls");

The output data is also stored within the $myproc object for later
retrieval.  You can also run a perl subroutine in a subprocess, with

   $myproc->run(sub { return <*>; });

The *run* Method will try to run the named process.  If the 
process times out (after *time_per_try* seconds) or has an
error defined as unacceptable and you would like to re-run it,
you can use the *num_tries* option.  Use the *time_btw_tries*
option to set the number of seconds between runs.  This can repeat
until *maxtime* seconds have elapsed.

When using *num_tries*, the user can specify what constitutes an
unacceptable error of STDOUT or STDERR output -- i.e. demanding a retry.
One common shorthand is to have the *run* method retry if there
is any return from STDERR.  

   $myproc->accept_no_error();    # Re-try if any STDERR
   $myproc->pattern_stdout($pat); # require STDOUT to match regex $pat
   $myproc->pattern_stderr($pat); # require STDERR to match regex $pat

Subprocess completion is detected when the process closes all filehandles.
The process must then exit before child_exit_time expires, or it will be
killed.  If the subprocess does not exit, it is sent a TERM signal unless
sigterm_exit_time is 0.  then if it does not exit before sigterm_exit_time
expires, it is sent a KILL signal unless sigkill_exit_time is 0.  then if
it does not exit before sigkill_exit_time expires an error is generated.
waiting is done in 0.01 second increments.

Proc::Reliable is not MT-Safe due to signals usage.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*
%changelog
