%define module_name Prometheus-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Plack/Test.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.011
Release: alt1
Summary: A tiny Prometheus client
Group: Development/Perl
License: perl
URL: https://github.com/robn/Prometheus-Tiny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RO/ROBN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Prometheus::Tiny' is a minimal metrics client for the
Prometheus time-series database.

It does the following things differently to the Net::Prometheus manpage:

=over 4

=item *

No setup. You don't need to pre-declare metrics to get something useful.

=item *

Labels are passed in a hash. Positional parameters get awkward.

=item *

No inbuilt collectors, PSGI apps, etc. Just the metrics.

=item *

Doesn't know anything about different metric types. You get what you ask for.

=back

These could all be pros or cons, depending on what you need. For me, I needed a
compact base that I could back on a shared memory region. See
the Prometheus::Tiny::Shared manpage for that!

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/P*

%changelog
