# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Load/Conditional.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(MooseX/Storage.pm) perl(String/ShortHostname.pm) perl(Time/Local.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Puppet-DB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Object for easily getting Puppet DB data (e.g. facts, reports, etc)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MQ/MQTECH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides methods to make it easy to connect to the Puppet DB and to put the data into a form where it can
be manipulated more readily.

It can extract anything from the Puppet DB that is supported by the API.  See the Puppet docs for more information on
the API: https://puppet.com/docs/puppetdb/latest/api/index.html.  Although this module tries to make it easier and 
more approachable by abstracting away some complexity, it still requires a basic understanding of how the API works.  
There is a bunch of Perl scripts I have created that consumes this and other Puppet Perl modules I have written. They 
provide some examples of what can be done.  They are distributed in a Puppet module as they are generally only 
useful in a Puppet environment. Consequently the best way to install them is via the module.  The module can be found 
here: https://github.com/Q-Technologies/puppet-utility_scripts.

Here is an example of how to use `Puppet::DB':

    use Puppet::DB;

    my $puppet_db = Puppet::DB->new;

    $puppet_db->refresh_facts;
    my $facts = $puppet_db->allfacts_by_certname;

    say $facts->{testhost.example.com}{osfamily};

Would output `Suse' if there was a SLES system called `testhost.example.com'

The AST query system of the Puppet DB is supported: https://puppet.com/docs/puppetdb/latest/api/query/v4/ast.html.
Rather than specifying it in JSON, specify it as Perl data structures. This module will convert it to JSON when it
communicates with the Puppet DB.  Some sample queries:

    use Puppet::DB;
    use Data::Dumper;

    my $mode = "facts";
    my $fact = 'osfamily';
    my $value = 'RedHat';
    my $rule = { 'query'    => [ "and", ["=","name", $fact], 
                                        ["~", "value", $value ] ], 
                 "order_by" => [{"field" => "certname"}] };
   
    my $puppet_db = Puppet::DB->new;
    $puppet_db->refresh($mode, $rule);
    print Dumper( $puppet_db->results );

    my $fact = 'os.family';
    $mode = "fact-contents";
    $rule = { 'query'    => [ "...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.mkdn Changes README
%perl_vendor_privlib/P*

%changelog
