# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(AutoLoader.pm) perl(Chart/Lines.pm) perl(Config.pm) perl(Exporter.pm) perl(GD/Graph/lines.pm) perl(Glib.pm) perl(Gtk2.pm) perl(IO/File.pm) perl(MIME/Base64.pm) perl(Term/ReadLine.pm) perl(Text/FormatTable.pm) perl(Tk.pm) perl(Tk/Balloon.pm) perl(Tk/FileSelect.pm) perl(Tk/PNG.pm) perl(Tk/Pane.pm) perl(Tk/Table.pm) perl(Tk/Tree.pm) perl-podlators
# END SourceDeps(oneline)
Name:           perl-QWizard
Version:        3.15
Release:        alt1_21
Summary:        A very portable graphical question and answer wizard system
License:        GPL+ or Artistic 
Group:          Development/Perl
URL:            http://search.cpan.org/dist/QWizard/
Source0:        http://www.cpan.org/authors/id/H/HA/HARDAKER/QWizard-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(CGI.pm)
# These are not auto-detected since they're technically optional
# (they're the best of the alternative choices available on linux)
Requires:       perl(CGI.pm)
Requires:       perl(Gtk2.pm)
Requires:       perl(Chart/Lines.pm)
Source44: import.info

# neither are picked up automagically.

%description
The QWizard module allows script authors to concentrate on the
content of the forms they want their users to fill in without
worrying about the display.  It allows "Question Wizard" like
interfaces to be very easily created and the results of the input
easily acted upon.  Scripts written which are entirely based on
QWizard inputs are able to be run from the command line which will
show a Gtk2, Tk window or as a ReadLine interactive session or as a
CGI script without modification.  Script writers do not need to know
which interface is being used to display the resulting form(s) as it
should be transparent to the script itself.

Other wizard interfaces exist for perl, but this one strives very
hard to be both extensible and easy to code with requiring as little
work by script authors as possible.  It is also one of the only ones
that supports both web environments and windowing environments
without code modification required by the script author.

%prep
%setup -q -n QWizard-%{version}

%build
%{__perl} Makefile.PL INSTALLMAN1DIR=%_man1dir INSTALLDIRS=vendor
make %{?_smp_mflags}

%install

make pure_install PERL_INSTALL_ROOT=%{buildroot}

find %{buildroot} -type f -name .packlist -exec rm -f {} \;
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null \;

# rpm doc examples shouldn't be executable
chmod a-x examples/*.pl
# not needed perl script that is actually just a pod generator from dist
rm -f %{buildroot}%{perl_vendor_privlib}/QWizard_Widgets.pl

# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc examples/
%doc README
%{perl_vendor_privlib}/*

%changelog
