# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(IO/File.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Net/IP.pm) perl(Net/SSL.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(URI/Escape.pm) perl(XML/Simple.pm) perl(XML/XPath.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name QualysGuard-Request
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Simple interface to QualysGuard API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PD/PDEVLIN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Each XML response from the QualysGuard API has an associated doctype definition (DTD). Therefore each DTD has
an associated subclass of QualysGuard::Response. Below is a list of the QualysGuard functions supported
by QualysGuard::Request. 

=over

=item Qualys Function           QualysGuard::Response Subclass

=item ------------------        --------------------------------------

=item asset_data_report         QualysGuard::Response::AssetDataReport

=item asset_domain              QualysGuard::Response::GenericReturn

=item asset_domain_list         QualysGuard::Response::AssetDomainList 

=item asset_group               QualysGuard::Response::GenericReturn

=item asset_group_delete        QualysGuard::Response::GenericReturn

=item asset_group_list          QualysGuard::Response::AssetGroupList

=item asset_ip                  QualysGuard::Response::GenericReturn

=item asset_ip_list             QualysGuard::Response::AssetHostList

=item asset_range_info          QualysGuard::Response::AssetRangeInfo

=item asset_search              QualysGuard::Response::AssetSearchReport

=item get_host_info             QualysGuard::Response::HostInfo

=item get_tickets               QualysGuard::Response::RemediationTickets

=item iscanner_list             QualysGuard::Response::IScannerList

=item map                       QualysGuard::Response::MapReport

=item map-2                     QualysGuard::Response::MapReport2

=item map_report                QualysGuard::Response::MapReport

=item map_report_list           QualysGuard::Response::MapReportList

=item report_template_list      QualysGuard::Response::ReportTemplateList

=item scan                      QualysGuard::Response::ScanReport

=item scan_cancel               QualysGuard::Response::GenericReturn

=item scan_options              QualysGuard::Response::ScanOptions

=item scan_report               QualysGuard::Response::ScanReport

=item scan_report_delete        QualysGuard::Response::GenericReturn

=item scan_report_list          QualysGuard::Response::ScanReportList

=item scan_running_list         QualysGuard::Response::ScanRunningList

=item scan_target_history       QualysGuard::Response::ScanTargetHistory

=item scheduled_scans           QualysGuard::Response::ScheduledScans

=item ticket_delete             QualysGuard::Response::TicketDelete

=item ticket_edit               QualysGuard::Response::TicketEdit

=item ticket_list               QualysGuard::Response::TicketList

=item ticket_list_deleted       QualysGuard::Response::TicketListDeleted

=back



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/Q*

%changelog
