# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir/Install.pm) perl(Test/More.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define module_name Query-Param
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Lightweight object interface for parsing and creating
Group: Development/Perl
License: perl
URL: http://github.com/rlauer6/query-param.git

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BIGFOOT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module parses an application/x-www-form-urlencoded encode query
string and provides an object-oriented interface for accessing the
query parameters.

Multiple values for a parameter are stored as an array
internally. When accessed via `get', a scalar is returned for single
values, and an array reference for multiple values.

There are many modules that parse query strings, so why re-invent this
wheel?

=over 5

=item Simplicity

=over 10

=item * Provides exactly what's needed to parse, access, mutate, and
emit query strings - nothing more.

=item * Easy to learn: get, set, has, keys, to_string, pairs.

=item * No dependency on object systems, Moo, Moose, or Catalyst internals.

=back

=item Lazy Decoding and Isomorphic Round-Tripping

=over 10

=item * Only decodes values on demand, saving effort when you only need a subset.

=item * Preserves semantics on `to_string()' - values go in and come
back out encoded correctly, even if original encoding format differed
(+ vs %%20).

=item * Isomorphic: `to_string()' and `new()' are inverse operations, as
long as values are treated semantically.

=back

=item No Magic or Global Side Effects

=over 10

=item * Doesn't touch global vars (%%ENV, @ARGV, etc.).

=item * Doesn't guess whether it's parsing a GET or POST - you pass it
a string explicitly.

=item * Can be used safely inside other frameworks or handlers without
surprises.

=back

=item Consistent, Predictable Behavior

=over 10

=item * Every key always returns a single value or an arrayref -
consistent rules.

=item * `set()' replaces; multiple values only come from the original
string or if assigned intentionally.

=back

=item Tiny Footprint

=over 10

=item * Just `URI::Escape', no other non-core deps.

=item * Lightweight enough for CLI tools, embedded apps, or mod_perl
handlers.

=back

=item CPAN Alternatives Can Be Overkill

=over 10

=item * CGI is bloated, global, and tied to the web environment.

=item * `CGI::Tiny' is good, but intentionally avoids mutation - no
`set()'.

=item * `Plack::Re...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ChangeLog
%perl_vendor_privlib/Q*

%changelog
