# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(List/SomeUtils.pm) perl(Pegex.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Query-Tags
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.3
Release: alt1
Summary: Raku-inspired query language for attributes
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBS/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Query::Tags implements a simple query language for stringy object attributes.
Its main features are:

=over

=item Attribute syntax

`:key(value)' designates that an object should have a field or method
named `key' whose value should match `value'. If `value' is
missing (is `undef'), the key or field should exist.

=item Regular expressions

Perl regular expressions are fully supported.

=item Junctions

Simple logic operations on queries is supported in the form of junctions
(as in Raku). For example, `:title!</Dummies/ /in \d+ days/>' matches
all books whose `title' field matches neither `/Dummies/' nor makes an
`/in \d+ days/'.

=item Pegex grammar

The language is specified using a the Pegex manpage grammar which means that it can
be easily changed and extended. You can also supply your own the Pegex::Receiver manpage
to the Pegex parser engine, for instance to compile a Query::Tags query to SQL.

=back

This feature set allows for reasonably flexible filtering of tagged, unstructured
data (think of email headers). They also allow for a straightforward query syntax
and quick parsing (discussed in detail below).

It does not support:

=over

=item Nested data structures

There is no way to match values inside a list, for example.

=item Types

There is no type information. All matching is string-based. There are no
operators for comparing numbers, dates or ranges (but they could be added
without too much work).

=item Complex logic

Junctions provide only a limited means for using logical connectives with
query assertions. You *can* specify "all books whose title is X or Y" but
you *cannot* specify "all books whose title is X or whose author is Y".

=back

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/Q*

%changelog
