%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Net/Telnet.pm)
# END SourceDeps(oneline)
%define module_version 1.04
%define module_name RAS-AS5200
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: PERL Interface to Cisco AS5200 Access Router
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/ST/STIGMATA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
At this time, the following methods are implemented:

=over 4

=item creating an object with new

Use the new() method to create a new object.

   Example:
      use RAS::AS5200;
      $foo = new RAS::AS5200(
         hostname => 'dialup1.example.com',
         login => '!root',
         password => 'mysecret',
         truncateusernames => 'true'
      );

The following variables are useful:
   hostname - The hostname of the router to connect to
   login - The login name to get a command-line on the router
   password - The password to the login name supplied
   enablepassword - The enable password to the router
   truncateusernames - See below
   prompt - See below

Since there's no point in dynamically changing the hostname, login, etc. these settings are static and must be supplied to the constructor. No error will be returned if these settings are not specified (except for the hostname, which is required), but your program will likely not get very far without at least a hostname and a correct password. Some older IOS versions such as Version 11.2(15a) only require a password and not a login name -- if a login name is supplied, it is assumed that your router is not one of these and a full login-and-password script will be used; if a login name is not supplied, it is assumed that your router only requires a password to log in.

The enablepassword is only required if you'll be using commands that require enable status on the router. This includes the userkill() and killexcessoutoctets() methods and would also include, for example, run_command('reload').

If the "truncateusernames" option is set to non-null, then usernames supplied to user-seeking functions such as userkill() and usergrep() will be internally truncated to 10 characters. This is to work around a "feature" of the AS5200 that only the first 10 characters of a login name are displayed, which would cause usergrep('johnjjschmidt') to never work, as the AS5200 displays the login name as 'johnjjschm'. See the TRUNCATING USER NAMES section for more discussion on this.

Prompt handling has been vastly improved. If a prompt is not specified, a reasonable default is assumed that should work just fine. If you want to specify a prompt, supply a regular expression without delimiters or anchors that represents your router's prompt, e.g. prompt => 'as5200[>#]' If you get errors about a bad match operator or a bad delimiter, you likely specified anchros and/or delimiters.


=item printenv

This is for debugging. It prints to STDERR a list of its configuration hash, e.g. the hostname, login, and password. The printenv method does not return a value.

   Example:
      $foo->printenv;


=item run_command

This takes a list of commands to be executed on the AS5200, executes the commands, and returns a list of references to arrays containg the text of each command's output. Repeat: It doesn't return an array, it returns an array of references to arrays. Each array contains the text output of each command. Think of it as an array-enhanced version of PERL's `backtick` operator.

Some router functions (e.g. rebooting) ask for confirmation - confirmation will be automatically supplied by the module's interface routine.

   Example:
      # Execute a command and print the output
      $command = 'show modems';
      ($x) = $foo->run_command($command);
      print "Output of command \'$command\':\n", @$x ;

   Example:
      # Execute a string of commands
      # and show the output from one of them
      (@output) = $foo->run_command('show isdn status','show modems');
      print "Modems:\n@$output[0]\n\n";;
      print "Current connections:\n@$output[1]\n\n";;

In Cisco-land, some functions are only available in enabled mode. To specify that a command should be run in enabled mode, prefix the command with "ENABLE " - that's all caps and a single space between the ENABLE and the rest of the command.

   Example:
      # Reboot the router
      $foo->run_command('ENABLE reload');


=item usergrep

Supply a username as an argument, and usergrep will return an array of ports on which that user was found (thus, an empty list if they weren't found). An undefined value is returned if no username was supplied. Internally, this does a run_command('show users') and processes the output.

   Example:
      @ports = $foo->usergrep('gregor');
      print "User gregor was found on ports @ports\n";


=item userkill

This does a usergrep, but with a twist: it disconnects the user by resetting the modem on which they're connected. Like usergrep, it returns an array of ports to which the user was connected before they were reset (or an empty list if they weren't found). The undefined value is returned if no username is supplied.

   Examples:
      @foo = $foo->userkill('gregor');
      print "Gregor was on ports @foo - HA HA!\n" if @ports ;

      @duh = $foo->userkill('-');
      print "There were ", scalar(@duh), " ports open.\n";


=item portusage

This returns an array: The 1st element is the number of ports. The rest is a list of users who are currently online.

   Examples:
      ($ports,@people) = $foo->portusage;
      print "There are $ports total ports.\n";
      print "There are ", scalar(@people), "people online.\n";
      print "They are: @people\n";

      ($ports,@people) = $foo->portusage;
      print "Ports free: ", $ports - scalar(@people), "\n";
      print "Ports used: ", scalar(@people), "\n";
      print "Ports total: ", $ports, "\n";


=item userports

This returns a hash with the key of each item being a username. The value of each item is an array of the ports that that username is currently using. This provides some information that a simple usergrep() lacks.

   Example:
      %%userports = $foo->userports;
      foreach $user (keys(%%userports)) {
        foreach $port (@{$userports{$user}}) {
             print "User: $user is on $port\n";
         }
      }


=item killexcessoutoctets

Takes a bytelimit as an argument and then checks each port's out-octets count. If the out octet count is higher than the bytelimit, the interface and its counters are reset. This is useful to stop RADIUS counters from wrapping, since a 32-bit signed integer wraps into negative at about 2 gig.

   Example:
      # kills users with outoctets of over about 2 gig
      $foo->killexcessoutoctets(2100000000);




%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/R*

%changelog
