%define module_name RDF-Endpoint
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config/ZOMG.pm) perl(Data/Dumper.pm) perl(Data/Perl/Role/Collection/Hash.pm) perl(Encode.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(HTML/HTML5/Writer.pm) perl(HTTP/Negotiate.pm) perl(HTTP/Request/Common.pm) perl(Hash/Merge/Simple.pm) perl(IO/Compress/Gzip.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Plack/Middleware/AccessLog.pm) perl(Plack/Request.pm) perl(Plack/Response.pm) perl(RDF/Query.pm) perl(RDF/RDFa/Generator.pm) perl(RDF/Trine.pm) perl(RDF/TrineX/Compatibility/Attean.pm) perl(Test/More.pm) perl(Test/WWW/Mechanize/PSGI.pm) perl(URI/Escape.pm) perl(URI/QueryParam.pm) perl(XML/LibXML.pm) perl(YAML/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: A SPARQL Protocol Endpoint implementation
Group: Development/Perl
License: zlib
URL: https://metacpan.org/release/RDF-Endpoint/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GW/GWILLIAMS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This modules implements the SPARQL Protocol for RDF using the PSGI
interface provided by the Plack manpage. It may be run with any Plack handler.
See the Plack::Handler manpage for more details.

When this module is used to create a SPARQL endpoint, configuration variables
are loaded using the Config::JFDI manpage. An example configuration file rdf_endpoint.json
is included with this package. Valid top-level configuration keys include:

=over 4

=item store

This is used to define the underlying the RDF::Trine::Store manpage for the
endpoint.  It can be a hashref of the type that can be passed to
the RDF::Trine::Store manpage->new_with_config, but a simple string can also be
used.

=item endpoint

A hash of endpoint-specific configuration variables. Valid keys for this hash
include:

=over 8

=item update

A boolean value indicating whether Update operations should be allowed to be
executed by the endpoint.

=item load_data

A boolean value indicating whether the endpoint should use URLs that appear in
FROM and FROM NAMED clauses to construct a SPARQL dataset by dereferencing the
URLs and loading the retrieved RDF content.

=item service_description

An associative array (hash) containing details on which and how much information
to include in the service description provided by the endpoint if no query is
included for execution. The boolean values 'default' and 'named_graphs' indicate
that the respective SPARQL dataset graphs should be described by the service
description.

=item html

An associative array (hash) containing details on how results should be
serialized when the output media type is HTML. The boolean value 'resource_links'
specifies whether URI values should be serialized as HTML anchors (links).
The boolean value 'embed_images' specifies whether URI values that are typed as
foaf:Image should be serialized as HTML images. If 'embed_images' is true, the
integer value 'image_width' specifies the image width to be used in the HTML
markup (letting the image height scale appropriately).

=back

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/R*
%perl_vendor_privlib/auto/*

%files scripts
%_bindir/*

%changelog
