# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/General.pm) perl(Data/Dumper.pm) perl(Getopt/Long.pm) perl(HTTP/Request.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Module/Build/Compat.pm) perl(Mouse.pm) perl(Pod/Usage.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(URL/Encode.pm)
# END SourceDeps(oneline)
%define module_version 0.1
%define module_name RDF-NLP-SPARQLQuery
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt1
Summary: Perl extension for converting Natural Language Questions in SPARQL queries
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TH/THHAMON/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module aims at querying RDF knowledge base with questions
expressed in Natural language. Natural language questions are
converted in SPARQL queries. The method is based on rules and
resources.  Resources are provided for querying the Drugbank
(<http://www.drugbank.ca >), Diseasome (<http://diseasome.eu>) and
Sider (<http://sideeffects.embl.de>).

The Natural language question has been already annotated with
linguistic and semantic information. Input file provides this
information (see details regarding the format in the section INPUT
FORMAT).

The object 6 fields: 

=over 4

=item *

`files' is a hashtablecontaining the name of the three files which are useful for running the converter (the configuration filename in the key `config' and the file name where the semantic correspondance and the rewriting rules are defined in the key `semtypecorresp').

=item *

`config' contains the configuration structure.

=item *

`questions' contains the list of natural language questions.

=item *

`semtypecorresp' contains the semantic correspondance and the rewriting rules to egenerate the SPARQL queries.

=item *

`format' contains the format of the output. Accepted values are `SPARQL' (the SPARQL query), `XML' (the SPARQL query in the QALD challenge XML format), `SPARQLANSWERS' (the answers return by the SPARQL query), `XMLANSWERS' (the answers return by the SPARQL query in the QALD challenge XML format).

=item *

`verbose' specifies the verbose level.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes TODO AUTHORS LICENSE examples
%perl_vendor_privlib/R*
/etc/nlquestion/*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
