# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(DateTime.pm) perl(DateTime/Format/Duration.pm) perl(DateTime/Format/ISO8601.pm) perl(DateTime/Format/Natural.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(RDF/Query.pm) perl(RDF/Query/Error.pm) perl(RDF/TrineX/Functions.pm) perl(Socket.pm) perl(Test/More.pm) perl(base.pm) perl(inc/Module/Package.pm) perl(overload.pm) perl(utf8_heavy.pl)
# END SourceDeps(oneline)
%define module_version 0.002
%define module_name RDF-Query-Functions-Buzzword-DateTime
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: plugin for buzzword.org.uk datetime functions
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/RDF-Query-Functions-Buzzword-DateTime

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a plugin for RDF::Query providing a number of extension functions
for dates and times.

=over

=item * http://buzzword.org.uk/2011/functions/datetime#add

Given an xsd:dateTime or xsd:date, and an xsd:duration, adds the
duration to the datetime. Returns an xsd:date if it was passed an
xsd:date and the xsd:duration didn't specify any hours, minutes or
seconds. Returns an xsd:dateTime otherwise.

=item * http://buzzword.org.uk/2011/functions/datetime#difference

Given two xsd:dateTime or xsd:date literals, returns an xsd:duration
representing the difference between them.

=item * http://buzzword.org.uk/2011/functions/datetime#format_duration

Given an xsd:duration and a literal formatting string, returns a
formatted duration. See the DateTime::Format::Duration manpage.

=item * http://buzzword.org.uk/2011/functions/datetime#now

Returns the current xsd:dateTime, with supposed nanosecond precision.
If called multiple times in the same SPARQL query, will always return
the same instant.

=item * http://buzzword.org.uk/2011/functions/datetime#strftime

Takes a xsd:datetime and a literal formatting string and returns
a formattted date. See the DateTime manpage.

=item * http://buzzword.org.uk/2011/functions/datetime#strtodate

Attempts to parse an arbitrary literal using natural language and
convert it into an xsd:date. Smart enough to tell the difference
between "1/6/1980"@en-us and "1/6/1980"@en-gb.

Can safely be passed an existing xsd:date or xsd:dateTime.

=item * http://buzzword.org.uk/2011/functions/datetime#strtotime

As per `strtodate' but returns an xsd:dateTime.

`add', `difference' and `strftime' all implicitly call `strtotime'
on their xsd:dateTime arguments, which means they don't need to be
given strict xsd:date/dateTime input.

=item * http://buzzword.org.uk/2011/functions/datetime#today

Like `now' but returns an xsd:date.

=back

=begin trustme

=item `install'

=end trustme


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_privlib/R*

%changelog
