%define module_name RDF-Trine
%add_findreq_skiplist %perl_vendor_privlib/RDF/Trine/Store/Redland.pm
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Combinatorics.pm) perl(CPAN.pm) perl(Cache/LRU.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Connector.pm) perl(Data/UUID.pm) perl(Digest/MD5.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Error.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(GraphViz.pm) perl(HTTP/Headers.pm) perl(HTTP/Negotiate.pm) perl(HTTP/Request/Common.pm) perl(IRI.pm) perl(JSON.pm) perl(LWP/MediaTypes.pm) perl(LWP/UserAgent.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Log/Log4perl.pm) perl(Math/BigInt.pm) perl(Module/Build.pm) perl(Module/Load/Conditional.pm) perl(Moose.pm) perl(MooseX/ArrayRef.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(RDF/EARL.pm) perl(Redis.pm) perl(Scalar/Util.pm) perl(Set/Scalar.pm) perl(Storable.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Data/Perl/Role/Collection/Hash.pm)
BuildRequires: perl(Test/JSON.pm) perl(Test/More.pm) perl(Text/CSV_XS.pm) perl(Text/Table.pm) perl(Time/HiRes.pm) perl(URI.pm) perl(XML/CommonNS.pm) perl(XML/Namespace.pm) perl(XML/SAX.pm) perl(XML/SAX/Base.pm) perl(YAML/Tiny.pm) perl(threads.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.019
Release: alt1
Summary: An RDF Framework for Perl
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/RDF-Trine/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GW/GWILLIAMS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
RDF::Trine provides an Resource Descriptive Framework (RDF) with an emphasis on
extensibility, API stability, and the presence of a test suite. The package
consists of several components:

=over 4

=item * RDF::Trine::Model - RDF model providing access to a triple store. This module would typically be used to access an existing store by a developer looking to "Just get stuff done."

=item * RDF::Trine::Parser - RDF parsers for various serialization formats including RDF/XML, Turtle, RDFa, and RDF/JSON.

=item * RDF::Trine::Store::Memory - An in-memory, non-persistant triple store. Typically used for temporary data.

=item * RDF::Trine::Store::DBI - A triple store for MySQL, PostgreSQL, and SQLite, based on the relational schema used by Redland. Typically used to for large, persistent data.

=item * RDF::Trine::Iterator - Iterator classes for variable bindings and RDF statements, used by RDF::Trine::Store, RDF::Trine::Model, and RDF::Query.

=item * RDF::Trine::Namespace - A convenience class for easily constructing RDF::Trine::Node::Resource objects from URI namespaces.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\![[:space:]]*\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc Changes.ttl README examples
%perl_vendor_privlib/T*
%perl_vendor_privlib/R*

%files scripts
%_bindir/*

%changelog
