# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest/Keccak.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/BigInt.pm) perl(Module/Load.pm) perl(Test/Code/TidyAll.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(indirect.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name REFECO-Blockchain-Contract-Solidity-ABI-Encoder
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Contract Application Binary Interface argument encoder
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RE/REFECO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Contract Application Binary Interface (ABI) is the standard way to interact
with contracts (Ethereum), this module aims to be an utility to encode the given
data according ABI type specification.

    my $encoder = REFECO::Blockchain::Contract::Solidity::ABI::Encoder->new();
    $encoder->function('test')
        # string
        ->append(string => 'Hello, World!')
        # bytes
        ->append(bytes => unpack("H*", 'Hello, World!'))
        # tuple
        ->append('(uint256,address)' => [75000000000000, '0x0000000000000000000000000000000000000000'])
        # arrays
        ->append('bool[]', [1, 0, 1, 0])
        # multidimensional arrays
        ->append('uint256[][][2]', [[[1]], [[2]]])
        # tuples arrays and tuples inside tuples
        ->append('((int256)[2])' => [[[1], [2]]])->encode();
    ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/R*

%changelog
