%define module_name REST-Neo4p
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Exception/Class.pm) perl(HOP/Stream.pm) perl(HTTP/Response.pm) perl(HTTP/Thin.pm) perl(HTTP/Tiny.pm) perl(IO/Pty.pm) perl(IPC/Run.pm) perl(JSON.pm) perl(JSON/XS.pm) perl(JSON/ize.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(List/MoreUtils.pm) perl(MIME/Base64.pm) perl(Mock/Quick.pm) perl(Module/Build.pm) perl(Mojo/Exception.pm) perl(Neo4j/Driver.pm) perl(Set/Scalar.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(Test/Warn.pm) perl(Tie/IxHash.pm) perl(Try/Tiny.pm) perl(URI/Escape.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4003
Release: alt1
Summary: Perl bindings for a Neo4j graph database
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAJENSEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
REST::Neo4p provides a Perl 5 object framework for accessing and
manipulating a Neo4j graph database server via the
Neo4j REST API. Its goals are

(1) to make the API as transparent as possible, allowing the user to
work exclusively with Perl objects, and

(2) to exploit the API's self-discovery mechanisms, avoiding as much
as possible internal hard-coding of URLs.

Neo4j entities are represented by corresponding classes:

=over

=item *

Nodes : REST::Neo4p::Node

=item *

Relationships : REST::Neo4p::Relationship

=item *

Indexes : REST::Neo4p::Index

=back

Actions on class instances have a corresponding effect on the database
(i.e., REST::Neo4p approximates an ORM).

The class the REST::Neo4p::Query manpage provides a DBIesqe Cypher query facility.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/R*

%changelog
