# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Class/CSV.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Pluggable.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(Text/Table.pm) perl(XML/IODEF.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name RINO-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Perl extension for parsing and handling RINO data
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SAXJAZMAN/cif/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
# using the command line client
 $ rino -h
 $ rino -f /tmp/rino.xml -p table
 $ rino -f /tmp/rino.xml -p csv
 $ cat /tmp/rino.xml | rino -p json

 # using the lib
 use RINO::Client;

 my @input;
 while(<STDIN>){
    push(@input,$_);
 }
 my $iodef_xml = join("",@input);

 my $rino = RINO::Client->new(iodef => $iodef_xml);
 print $rino->write_out('table');
 print $rino->write_out('csv');
 print $rino->write_out('json');

 my $simple_hash = $rino->to_simple();
 my $complex_hash = $rino->to_hash();

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%files scripts
%_bindir/*

%changelog
