%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Class/ISA.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(IO/EventMux.pm) perl(IO/Socket/INET.pm) perl(Module/Build.pm) perl(Privileges/Drop.pm) perl(Socket.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.05
%define module_name RPC-Async
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: Asynchronous RPC framework
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TL/TLBDK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This set of module implements remote procedure calls between perl programs. It
is special in that control flow does not halt until the call has completed.
Instead, the call completes in the background until it eventually returns,
triggering a callback function in the client. By using anonymous sub references
(closures) in Perl, such control flow can be made to look quite linear despite
being non-blocking and interleaved.

This module uses the IO::EventMux manpage, the event-based frontend to the select(2) manpage, to
do parallel I/O without using threads. Users of this module must use
the IO::EventMux manpage to control their main loop, but this is still very flexible.

The two ends of this framework are documented in the RPC::Async::Client manpage and
the RPC::Async::Server manpage.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ChangeLog examples
%perl_vendor_privlib/R*

%changelog
