# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.0.5
%define module_name RPM-NEVRA
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.5
Release: alt1
Summary: Parses, validates NEVRA format
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SY/SYAGI/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
NEVRA is the best format to describe an RPM with full details.  The problem is, rpm's handling of epoch is different
from how repoquery handles epoch.  rpm omits the epoch when undefined, whereas repoquery thinks epoch was insignificant.
This subtle difference leads to incomplete queries such as this:

    $ repoquery bind-9.10.2-2.P1.fc22.x86_64
    bind-32:9.10.2-2.P1.fc22.x86_64

In the above example, I had the bind package from rpm -qa, which omitted epoch because it was undefined.  However, when
I feed it to repoquery, it gave me back with a package with epoch of 32.  This was an ambiguous query and the solution
is to ALWAYS specify the epoch in repoquery queries.

    use RPM::NEVRA;

    my $obj = RPM::NEVRA->new();
    my %%info = $obj->parse_nevra('bind-32:9.10.2-2.P1.fc22.x86_64');
    print $info{epoch}; # prints 32

    my ( $is_nevra, $missing ) = $obj->is_nevra('bind-9.10.2-2.P1.fc22.x86_64'); # returns ( 0, 'epoch' )
    my $str = $obj->convert_to_nevra('bind-9.10.2-2.P1.fc22.x86_64'); # returns 'bind-0:9.10.2-2.P1.fc22.x86_64'
%prep
%setup -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
