%define module_name RPi-MultiPCA9685
BuildRequires: perl-podlators
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(POSIX.pm) perl(RPi/I2C.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: control the PWM channels of several PCA9685 ICs in one go.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RJ/RJET/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Interface to set the PWM values for one or several PCA9685 ICs in one go.
PWM stands for "Pulse Width Modulation" - a technic for stepless control of 
electric devices to adjust LED brightness or Servo positions and much more. 
You may set the PWM channels of several consecutively addressed PCA9685 ICs  
by providing one single array reference that contains the pwm values for all 
of these chips. This Module may replace Device::PWMGenerator::PCA9685 as 
this Module is time consuming to install and starts slowly. MultiPCA9685.pm 
requires only RPi::I2C as a prequisite and not a huge module chain like 
Device::PWMGenerator::PCA9685. MultiPC9685.pm is especially useful in time 
critical applications, because it uses the continuous write feature of the chip
that saves a lot of addressing time. 

%package scripts
Summary: %name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/R*

%files scripts
%_bindir/*


%changelog
